/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.ErrorCode;
import cn.com.duiba.projectx.sdk.InnerBizCode;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.InitializationContext;
import cn.com.duiba.projectx.sdk.repeatable.ActionNode;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.ComponentFactory;
import cn.com.duiba.projectx.sdk.repeatable.NodeFactory;
import cn.com.duiba.projectx.sdk.repeatable.Response;
import cn.com.duiba.projectx.sdk.repeatable.annotation.LocalInvoke;
import cn.com.duiba.projectx.sdk.repeatable.annotation.RemoteInvoke;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent<I extends UserRequestApi>
implements Component<I> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponent.class);
    protected final String id;
    private final Map<String, Method> methodMaps = new HashMap<String, Method>();
    private final Map<String, Method> remoteMethodMaps = new HashMap<String, Method>();

    public AbstractComponent(String id) {
        Map map = Arrays.stream(this.getClass().getMethods()).filter(m -> m.isAnnotationPresent(LocalInvoke.class)).collect(Collectors.toMap(Method::getName, Function.identity()));
        for (Method method : map.values()) {
            Class<?> returnType = method.getReturnType();
            if (Response.class.isAssignableFrom(returnType)) continue;
            LOGGER.error("\u672c\u5730\u65b9\u6cd5\u521d\u59cb\u5316\u5931\u8d25\uff0c{}.{}\u65b9\u6cd5\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aResponse", (Object)this.getClass().getName(), (Object)method.getName());
            throw new IllegalStateException("\u672c\u5730\u65b9\u6cd5\u521d\u59cb\u5316\u5931\u8d25");
        }
        this.methodMaps.putAll(map);
        this.remoteMethodMaps.putAll(Arrays.stream(this.getClass().getMethods()).filter(m -> m.isAnnotationPresent(RemoteInvoke.class)).collect(Collectors.toMap(Method::getName, Function.identity())));
        this.id = id;
    }

    public static <I extends UserRequestApi> ActionNode<I> nodeWithAction(Class<? extends Component<I>> componentClass, String action, InitializationContext initializationContext) {
        return AbstractComponent.nodeWithAction(componentClass, action, initializationContext, "");
    }

    public static <I extends UserRequestApi> ActionNode<I> nodeWithAction(Class<? extends Component<I>> componentClass, String action, InitializationContext initializationContext, String id) {
        Component component = ComponentFactory.createAndRegister(componentClass, initializationContext, id);
        ActionNode node = new ActionNode(component, action);
        NodeFactory.put(node);
        return node;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Method getAction(String name) {
        return this.methodMaps.get(name);
    }

    @Override
    public Method getRemoteAction(String name) {
        return this.remoteMethodMaps.get(name);
    }

    @Override
    public Object doRemoteAction(String actionName, Object ... args) {
        try {
            Method action = this.remoteMethodMaps.get(actionName);
            if (action == null) {
                throw new BizRuntimeException(ErrorCode.ERR_10021, "\u65b9\u6cd5\u4e0d\u5b58\u5728");
            }
            return action.invoke((Object)this, args);
        }
        catch (BizRuntimeException biz) {
            throw biz;
        }
        catch (Throwable t) {
            LOGGER.error("\u6267\u884c\u5931\u8d25", t);
            LOGGER.warn("\u65b9\u6cd5\u5185\u90e8\u6267\u884c\u5931\u8d25:{}.{}", new Object[]{this.getClass(), actionName, t.getCause()});
            throw new BizRuntimeException(InnerBizCode.SYSTEM_ERROR);
        }
    }
}

