/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable.mvp;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.ErrorCode;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.playway.InitializationContext;
import cn.com.duiba.projectx.sdk.repeatable.ActionChain;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.ComponentFactory;
import cn.com.duiba.projectx.sdk.repeatable.EventContext;
import cn.com.duiba.projectx.sdk.repeatable.EventContextType;
import cn.com.duiba.projectx.sdk.repeatable.FlowConfig;
import cn.com.duiba.projectx.sdk.repeatable.Response;
import cn.com.duiba.projectx.sdk.repeatable.annotation.DevConfig;
import cn.com.duiba.projectx.sdk.repeatable.utils.ReflectUtils;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public interface Mvp
extends EventContextType {
    public InitializationContext getInitializationContext();

    default public <I extends UserRequestApi> Response<I> invokeChain(ActionChain<I> actionChain, EventContext eventContext, UserRequestContext userRequestContext, I api) {
        return actionChain.invoke(eventContext, userRequestContext, api);
    }

    default public void init() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        String configClassName = className.substring(0, index + 1) + "CustomConfig";
        try {
            Class<?> clazz = Class.forName(configClassName, true, this.getClass().getClassLoader());
            FlowConfig flowConfig = (FlowConfig)clazz.newInstance();
            flowConfig.config(this);
        }
        catch (Throwable e) {
            throw new RuntimeException(className + "\u73a9\u6cd5\u89e3\u6790\u914d\u7f6e\u9519\u8bef", e);
        }
    }

    default public void populate(Mvp mvp, Map<String, String> configMap) {
        Field[] fields;
        for (Field field : fields = mvp.getClass().getDeclaredFields()) {
            double aDouble;
            DevConfig devConfig = field.getAnnotation(DevConfig.class);
            if (devConfig == null) continue;
            String key = devConfig.key();
            String value = configMap.get(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new BizRuntimeException("\u627e\u4e0d\u5230[" + mvp.getClass().getName() + "." + key + "]\u914d\u7f6e");
            }
            if (NumberUtils.isCreatable((String)value) && ((aDouble = Double.parseDouble(value)) < devConfig.minInclude() || aDouble >= devConfig.maxExclude())) {
                throw new BizRuntimeException(String.format("%s\u503c\u6821\u9a8c\u51fa\u9519,\u8981\u6c42[%s,%s),\u5b9e\u9645:%s", key, devConfig.minInclude(), devConfig.maxExclude(), value));
            }
            ReflectUtils.assign(field, mvp, value);
        }
    }

    default public Object remoteInvoke(Class<? extends Component<? extends UserRequestApi>> componentClass, UserRequestContext context, Object ... args) {
        Component component;
        String cpId;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String methodName = stackTrace[2].getMethodName();
        if (methodName.contains("_")) {
            methodName = methodName.substring(methodName.lastIndexOf("_") + 1);
        }
        if ((cpId = context.getHttpRequest().getParameter("cp_id")) == null) {
            cpId = "";
        }
        if ((component = ComponentFactory.get(componentClass, cpId)) == null) {
            throw new BizRuntimeException(ErrorCode.ERR_10021, "\u7ec4\u4ef6\u4e0d\u5b58\u5728");
        }
        return component.doRemoteAction(methodName, args);
    }
}

