package cn.com.duiba.projectx.sdk.playway.scoring;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.dto.ActionRecordDto;

/**
 * 记分玩法API
 * 1.用户请求记分玩法的接口时，自定义代码区域可使用此API
 *
 * @author houwen
 */
public interface ScoringUserRequestApi extends UserRequestApi {


    /**
     * 提交分数
     * @param startId 参与记录
     * @param score 提交的分数
     */
    void submitScore(long startId, int score);

    /**
     * 查询我的今日参与次数
     * 游戏参与次数，只计算action=start
     * @return 用户当前活动今日的参与次数
     */
    Long queryMyTodayCount();

    /**
     * 通过id查询参与记录
     * @param startId 参与id
     * @return ActionRecordDto
     */
    ActionRecordDto findById(long startId);

    /**
     * 查询一次游戏提交的次数
     * @param startId 参与id
     * @return 次数
     */
    int countTimes(long startId);

}
