package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.InitializationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

/**
 * 抽象组件
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AbstractComponent.java , v 0.1 2020-01-21 11:31 上午 ZhouFeng Exp $
 */
public abstract class AbstractComponent<I extends UserRequestApi> implements Component<I> {
    /**
     * logger
     */
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponent.class);

    private ComponentContext<I> context;

    private String id;


    public AbstractComponent(String id) {
        this.id = id;
        context = new ComponentContext<>(this);
    }


    public static <I extends UserRequestApi> ActionNode<I> nodeWithAction(Class<? extends Component<I>> componentClass, String action, InitializationContext initializationContext) {
        return nodeWithAction(componentClass, action, initializationContext, "");
    }

    public static <I extends UserRequestApi> ActionNode<I> nodeWithAction(Class<? extends Component<I>> componentClass, String action, InitializationContext initializationContext, String id) {
        Component<I> component = ComponentFactory.createAndRegister(componentClass, initializationContext, id);
        ActionNode<I> node = new ActionNode<>(component, action);
        //将创建的node自动注册到工厂中
        NodeFactory.put(node);
        return node;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public Method getAction(String name) {
        return context.getLocalAction(name);
    }

    @Override
    public Method getRemoteAction(String name) {
        return context.getRemoteAction(name);
    }

    @Override
    public Object doRemoteAction(String actionName, Object... args) {
        return context.doRemoteAction(actionName, args);
    }
}
