package cn.com.duiba.projectx.sdk.playway.scoring;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.dto.ActionRecordDto;
import cn.com.duiba.projectx.sdk.playway.base.Ranking;
import cn.com.duiba.projectx.sdk.playway.base.RankingUserPrizeRecord;

import java.util.List;

/**
 * 记分玩法API
 * 1.用户请求记分玩法的接口时，自定义代码区域可使用此API
 *
 * @author houwen
 */
public interface ScoringUserRequestApi extends UserRequestApi {


    /**
     * 提交分数
     * @param startId 参与记录
     * @param score 提交的分数
     */
    void submitScore(long startId, int score);

    /**
     * 查询我的今日参与次数
     * 游戏参与次数，只计算action=start
     * @return 用户当前活动今日的参与次数
     */
    Long queryMyTodayCount();

    /**
     * 通过id查询参与记录
     * @param startId 参与id
     * @return ActionRecordDto
     */
    ActionRecordDto findById(long startId);

    /**
     * 查询一次游戏提交的次数
     * @param startId 参与id
     * @return 次数
     */
    int countTimes(long startId);

    /**
     * 获取前几名的排行榜信息
     * @param topN 前几名
     *             不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(int topN);


    /**
     * 获取上期排行榜当前用户信息
     * 活动结束就是最后一期的上一期
     * @return
     */
    RankingUserPrizeRecord getPreMyRank();


    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType() throws BizRuntimeException;

}
