/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk;

public class Result<T> {
    private boolean success;
    private String message;
    private String code;
    private T data;

    private Result(boolean success) {
        this.success = success;
    }

    public Result() {
    }

    public static <T> Result<T> success() {
        return new Result<T>(true);
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = Result.success();
        result.setData(data);
        return result;
    }

    public static <T> Result<T> fail() {
        return new Result<T>(false);
    }

    public static <T> Result<T> fail(String message) {
        Result<T> result = Result.fail();
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> fail(Integer code, String message) {
        Result<T> result = Result.fail();
        result.setCode(String.valueOf(code));
        result.setMessage(message);
        return result;
    }

    public static <T> Result<T> fail(String code, String message) {
        Result<T> result = Result.fail();
        result.setCode(String.valueOf(code));
        result.setMessage(message);
        return result;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean succ) {
        this.success = succ;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }
}

