package cn.com.duiba.projectx.sdk.kv;

import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * @author zhangruofan
 * @date 2019/12/03
 */
public interface KvOperations {
    /**
     * increment the {@code value} and expiration {@code expire} for {@code key}.
     * @param key must not be null
     * @param delta delta
     * @param expire expire
     * @return 增加后的值
     */
    long increment(String key, long delta, Date expire);

    /**
     * Get the Long value of {@code key}.
     * @param key must not be null
     * @return value
     */
    Long getLongValue(String key);

    /**
     * Get the String value of {@code key}.
     * @param key must not be null
     * @return value
     */
    String getStringValue(String key);

    /**
     * set the {@code value} and expiration {@code expire} for {@code key}.
     * @param key must not be null
     * @param value value
     * @param expire expire
     * @return 是否set成功
     */
    boolean setStringValue(String key, String value, Date expire);
}
