package cn.com.duiba.projectx.sdk.pay;

import java.util.HashMap;
import java.util.Map;

public enum WxPayBankEnum {

    ICBC("工商银行","ICBC"),
    ABC("农业银行","ABC"),
    PSBC("邮储银行", "PSBC"),
    CCB("建设银行", "CCB"),
    CMB("招商银行","CMB"),

    ;

    WxPayBankEnum(String bankName,String bankCode){
        this.bankName = bankName;
        this.bankCode = bankCode;
    }
    private static final Map<String, WxPayBankEnum> ALL_ENUM_MAP = new HashMap<>();
    static{
        for(WxPayBankEnum bank : values()){
            ALL_ENUM_MAP.put(bank.getBankName(), bank);
        }
    }

    public static WxPayBankEnum getBank(String bankName) {
        return ALL_ENUM_MAP.get(bankName);
    }


    /** 银行名称 */
    private String bankName;
    /** 银行编码 */
    private String bankCode;


    public String getBankName() {
        return bankName;
    }
    public String getBankCode() {
        return bankCode;
    }
}
