package cn.com.duiba.projectx.sdk.pay;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * created by liugq in 2020/03/19
 * 微信支付h5 入参
*/
public class WxWapPayReq implements Serializable {

    private static final long serialVersionUID = -5114152793740661727L;
    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;
    /**
     * 业务方业务id，保证同一个项目下唯一
     */
    @NotNull
    private String bizId;

    /**
     * 支付成功回调地址
     */
    @NotNull
    private String callbackUrl;

    private String extra;

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }


    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }
}

