package cn.com.duiba.projectx.sdk.repeatable.annotation;

import cn.com.duiba.projectx.sdk.repeatable.mvp.Mvp;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 组件远程调用行为注解
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteInvoke.java , v 0.1 2020-01-21 5:40 下午 ZhouFeng Exp $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface RemoteInvoke {

    /**
     * 接口所在MVP类
     * 不设置此字段时，将会自动寻找相同玩法类型的MVP
     * 如果是通用组件，请不要设置此字段
     *
     * @return
     */
    Class<? extends Mvp> mvp() default Mvp.class;

    /**
     * 接口前缀
     * 接口格式为${prefix}_${id}
     *
     * @return
     */
    String prefix() default "";

    /**
     * 接口id
     * 接口格式为${prefix}_${id}
     *
     * @return
     */
    String id() default "";

    /**
     * 接口名称
     * 即为接口的描述
     *
     * @return
     */
    String name() default "";

}
