package cn.com.duiba.projectx.sdk.repeatable.mvp;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.repeatable.ActionChain;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ActionChains.java , v 0.1 2020-02-13 4:05 下午 ZhouFeng Exp $
 */
public class ActionChains {

    private static Table<Class<? extends Mvp>, String, ActionChain<?>> CHAINS = HashBasedTable.create();


    public static void put(Class<? extends Mvp> mvpClass, String name, ActionChain<?> actionChain) {
        CHAINS.put(mvpClass, name, actionChain);
    }

    /**
     * 获取MVP中的ActionChain
     *
     * @param mvpClass
     * @param name     ActionChain名称
     * @param <I>
     * @return
     */
    @SuppressWarnings("unchecked")
    public static <I extends UserRequestApi> ActionChain<I> getChain(Class<? extends Mvp> mvpClass, String name) {
        return (ActionChain<I>) CHAINS.get(mvpClass, name);
    }
}
