package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.data.Option;
import cn.com.duiba.projectx.sdk.data.ProjectWhiteListData;
import cn.com.duiba.projectx.sdk.data.UserPrizeRecord;
import cn.com.duiba.projectx.sdk.playway.base.Prize;
import cn.com.duiba.projectx.sdk.playway.base.PrizeStock;
import cn.com.duiba.projectx.sdk.playway.base.UserData;

import java.security.KeyStore;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface ProjectApi extends Api {

    PrizeStock getPrizeStock(String prizeId);

    /**
     * 批量获取奖品库存信息
     * @param ids prize ids
     * @return prize stock list
     */
    List<PrizeStock> listPrizeStock(List<String> ids);

    Prize getPrize(String prizeId);

    /**
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    void insertKvStringData(String key, String value, Date expireTime);

    /**
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    void putKvStringData(String key, String value);


    /**
     * 增加/减少数值
     *
     * @param key
     * @param offset 增量
     * @param expire 失效时间
     * @return 变更后的数值
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#increase(String, long, ExpireTime)}
     */
    @Deprecated
    long increase(String key, long offset, Date expire);


    /**
     * 获取kv中的数值
     *
     * @param key
     * @return 当值不存在时返回null，存在时返回实际数值
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#getLong(String)}
     */
    @Deprecated
    Long getKvLong(String key);

    /**
     * 添加/更新KV记录
     *
     * @param key
     * @param value
     * @param expireTime
     * @return
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#set(String, String, ExpireTime)}
     */
    @Deprecated
    boolean putKvStringData(String key, String value, Date expireTime);

    /**
     * 获取kv记录
     *
     * @param key
     * @return
     * @deprecated {@link UserRequestApi#getKeyValueApi()} {@link KeyValueApi#get(String)}
     */
    @Deprecated
    String getKvStringData(String key);

    /**
     * 给用户发放道具
     * @param userId userId
     *
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(String userId, String spId, int quantity);


    /**
     * 获取一个http请求实例,不同project之间相互隔离
     *
     * @return
     */
    HttpHelper getHttpHelper();

    /**
     * 获取一个https请求实例
     *
     * @param name     实例的名称，不同实例间隔离
     * @param keyStore 证书
     * @return
     */
    HttpHelper getHttpHelper(String name, KeyStore keyStore);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     */
    Boolean consumeStageProperty(String userId, String spId, int quantity);

    /**
     * 查询某人所有的道具的数量信息
     *
     * @param userId 需要查询的用户
     * @return key:道具id，value:拥有的道具数
     */
    Map<String, Long> getSomebodyAllStageProperty(String userId);

    /**
     * 查询某些用户的某个道具数
     * @param userIds 用户id最多支持1000人，超过抛异常
     * @param spId sp id
     * @return map user id -> sp count
     */
    Map<String, Long> getSpByUserIds(List<String> userIds, String spId);
    /**
     * 查询某人的某个道具的数量
     *
     * @param userId 需要查询的用户
     * @param spId   道具id
     * @return
     */
    Long getSomebodyStageProperty(String userId, String spId);

    /**
     * 获取某个发奖策略下面的奖项列表
     *
     * @param strategyId 发奖策略id
     * @return list
     */
    List<Option> queryOptions(String strategyId);

    /**
     * list user data
     * user id 的个数不能超过500个，超过会抛异常
     * @param key key
     * @param userIds user ids
     * @return user data list
     */
    List<UserData> batchListUserData(String key, List<String> userIds);

    /**
     * 判断某个用户是否是开发者白名单用户
     *
     * @param partnerUserId
     * @param projectId
     * @return user data list
     */
    Boolean isWhiteListUser(String projectId ,String partnerUserId);

    /**
     * 获取当前用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @return
     */
    List<UserPrizeRecord> listUserPrizeRecord(boolean ignoreAddCredits);

    /**
     * 获取制定用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     * @param userId 用户ID
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @return
     */
    List<UserPrizeRecord> listSomebodyUserPrizeRecord(String userId, boolean ignoreAddCredits);


    /**
     * 判断某个用户在当前项目是否是开发者白名单用户
     * @param partnerUserId
     * @param groupId 分组类型id （不使用传null，默认查所有组）
     * @return
     */
    Boolean isWhiteListUserByPIdAndGroupId(String partnerUserId ,String groupId);


    /**
     * 根据pid获取白名单用户信息（根据groupId去重）
     * @param partnerUserId
     * @return
     */
    List<ProjectWhiteListData> listWhiteByPartnerUserId(String partnerUserId);

    /**
     * sum sp record
     * 获取扣减的或者增加的总数
     * 只能永久道具使用。
     *
     * @param userId    user id
     * @param spId      sp id
     * @param type      + -
     * @return sum
     */
    Long sumSpRecord(String userId, String spId, String type);

}
