package cn.com.duiba.projectx.sdk.pay.citic;

import cn.com.duiba.projectx.sdk.pay.PayCenterBaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * Created by HePeng on 2020/11/05 15:00.
 */
public class CiticWapPayCenterChargeRequest extends PayCenterBaseChargeRequest {
    private static final long serialVersionUID = -5442376795325819346L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 订单时间 yyyyMMdd HHmmss
     */
    @NotNull(message = "订单时间不能为空")
    private String createDate;

    @NotNull(message = "商品类型不能为空")
    private String itemType;

    @NotNull(message = "消费者id不能为空")
    private String consumerId;

    @NotNull(message = "回调地址不能为空")
    private String callbackUrl;

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getItemType() {
        return itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }
}
