package cn.com.duiba.projectx.sdk.redacc;

import java.util.HashMap;

/**
 * 活动统一编码,新定义code从200起步
 * 维护文档：http://cf.dui88.com/pages/viewpage.action?pageId=13682861
 */
public enum  ActivityUniformityTypeEnum {
    //旧活动兼容，code与op表type一致
    AppSingleLottery(3, "自有单品抽奖"),
    DuibaSingleLottery(2, "兑吧单品抽奖"),
    ManualLottery(5, "手动开奖"),
    Bargain(26, "砍价活动"),
    Group(25, "拼团活动"),
    DuibaNgame(28, "游戏"),
    DuibaElasticGifts(49, "弹层活动"),
    Plugin(50, "插件"),
    BarrageSign(51, "弹层签到"),
    LotteryActivity(52, "博彩活动"),
    PK(53, "pk活动"),
    HDTool(100, "活动工具"),
    QuestionAnswer(101, "答题"),
    //新类型，以200起步
    FloorSign(201, "楼层签到"),
    CalendarSign(202, "日历签到"),
    ContractSign(203, "契约签到"),
    PetSign(204, "宠物养成"),
    ManageSign(205, "经营性签到"),
    BrickMover(56, "搬砖工"),
    RedPacketSquare(54,"红包广场"),
    SeedRedPacket(208, "种红包"),
    StealRedPacket(210,"偷红包"),
    VoteTool(209, "投票工具"),
    AppNewSeckill(211, "秒杀活动"),
    HappyGroup(212, "拼拼乐拼团活动"),
    SeedRedPacket_Old(213, "旧版种红包"),

    SignForNew(31001, "拉新日历签到"),


    /**
     * 通用化的活动类型对应code定义：以3开头
     */
    CollectCard(31000, "集卡活动"),
    FreeGroupTool(31002, "0元拼团工具"),
    LUCKY_CODE(31003, "幸运码活动"),

    ScrapeRedPacket(31004, "微信刮红包活动"),
    HappyCode(31005, "积分夺宝活动"),
    NewConsumer7DayPopup(31006, "7天新人弹窗"),
    PyramidSpread(31007, "全民赚佣金"),
    OpenRedPacket(31008, "拆红包工具"),
    SignTreasure(31009, "夺宝签到活动"),
    MiningMachine(31010, "无敌挖矿机"),
    Rank(31011, "排行榜开奖"),
    DigGold(31012, "挖金矿活动"),
    EQUITY(31013, "权益核销"),
    CREDITS_FARM(31014, "积分农场"),
    SIGN_CALENDAR_COMPONENT(31015, "日历签到组件化"),
    BaByMachine(31016, "娃娃机"),
    Haggle(31017, "砍价0元拿"),
    Centscan(31018, "一分扫"),
    SeedRedPacketH5(31019, "种红包独立H5活动"),

    /**
     * 定制化活动类型,从50001起自增
     */
    PiaoLiuXia_SignIn(50001,"漂流侠扑克牌签到"),
    YongHuiCollectCard_THREE(50002,"永辉集卡三期"),
    ShuqiLike(50004,"书旗点赞"),

    YongHui_InvitedNewUser(50005,"永辉新人有礼"),
    WatsonsJoinGroup(50006, "屈臣氏评团"),
    YongHui_SeedRedPacket(50008, "永辉种红包"),
    YongHui_ExpandRedPacket(50009, "永辉超市膨胀红包"),
    Yaduo_answer(50010, "亚多答题"),
    Cebbank(50011, "光大打星球需求"),
    Citic_Gifts(50012, "中信银行权益领取定制"),
    Qingting(50013, "蜻蜓FM 618活动"),
    SuzhouBank_Redpacket_Rain(50014, "苏州银行红包雨"),
    SuzhouBank_Sign(50015, "苏州银行签到"),
    SuzhouBank_Task_Center(50016, "苏州银行任务中心"),
    SuzhouBank_Seckill(50017, "苏州银行秒杀"),
    GaoDun_SignPet(50018, "高顿宠物养成"),
    HouBank_Guess_Redpacket(50019, "厚钱包猜红包"),
    Vienna_Lachine(50020, "维也纳拉新活动"),
    QQ_MUSIC_AUCTION(50021, "qq音乐商品拍卖"),
    HAIDILAO_SIGN_PET(50022,"海底捞火锅养成活动"),
    KunMing_CMBCHINA(50023,"昆明招行红包雨活动"),
    Happy_Clear(50024,"消消乐"),
    ShuQi_Pet(50025,"书旗叠小七"),
    Tianjin_cmbchina(50026,"天津招行"),
    CCB_BIG_WHEEL(50027, "建行-好礼赚不停"),
    Baidu(50028, "百度网盘行动"),
    CCB_ETC_QU_ZHOU(50029, "建行-衢州ETC活动发奖"),
    WEBANK_TURNTABLE(50030, "微众大转盘"),
    DALINGJIA_SIGN_PET(50031, "达令家养成"),
    HUARUN_GASHAPON(50032, "华润通扭蛋机"),
    ZHONGHONG_SWELL_RED_PACKET(50034, "中宏保险膨胀红包"),

    /**
     * 星速台模板活动类型,从70001起自增
     */
    PROJECTX(70000, "星宿台默认活动类型"),
    LIPSTICK(70001, "星速台 - 口红机模板活动"),
    STAR_WAR(70002, "星速台 - 打星球模板活动"),
    ANSWER(70003, "星速台 - 答题模板活动"),
    REDPACKET(70004, "星速台 - 拆红包模板活动"),
    ;

    private static HashMap<Integer, ActivityUniformityTypeEnum> typeMap = new HashMap<>();
    static{
        for(ActivityUniformityTypeEnum type : values()){
            typeMap.put(type.getCode(), type);
        }
    }

    public static ActivityUniformityTypeEnum getByCode(Integer code){
        return typeMap.get(code);
    }

    private Integer code;
    private String desc;

    ActivityUniformityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
