package cn.com.duiba.projectx.sdk.data;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 黄金矿工基础元素类型枚举
 * @author: liupu1
 * @create: 2020/11/9 10:29 AM
 **/
public enum GMElementEnum {

    ROCK_SMALL("rockSmall", "石块-小"),
    ROCK_MEDIUM("rockMedium", "石块-中"),
    ROCK_BIG("rockBig", "石块-中"),
    BULLION_SMALL("bullionSmall", "金块-小"),
    BULLION_MEDIUM("bullionMedium", "金块-中"),
    BULLION_BIG("bullionBig", "金块-大"),
    DIAMOND("diamond", "钻石"),
    ANIMAL("animal", "动物"),
    DIAMOND_ANIMAL("diamondAnimal", "带钻动物"),
    GARBAGE("garbage", "垃圾"),
    POWER_KEG("powerKeg", "炸药桶"),
    TREASUER_BOX("treasureBox", "宝箱"),;


    private String code;
    private String desc;

    GMElementEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, GMElementEnum> CODE_MAP = new HashMap<>();

    static {
        for (GMElementEnum statusEnum : values()) {
            CODE_MAP.put(statusEnum.getCode(), statusEnum);
        }
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
