package cn.com.duiba.projectx.sdk.data;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 黄金矿工道具枚举类型
 * @author: liupu1
 * @create: 2020/11/9 11:06 AM
 **/
public enum GMSpEnum {

    GOLD_COIN("goldCoin", "金币"),
    BOMB("bomb", "炸弹"),
    MIDAS_TOUCH("midasTouch", "点石成金"),
    LUCKY_CLOVER("luckyClover", "幸运草"),
    VIGOROUS_POTION("vigorousPotion", "大力药水"),
    POTENTIAL_STOCK("potentialStock", "潜力股"),;


    private String code;
    private String desc;

    GMSpEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, GMSpEnum> CODE_MAP = new HashMap<>();

    static {
        for (GMSpEnum spEnum : values()) {
            CODE_MAP.put(spEnum.getCode(), spEnum);
        }
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
