package cn.com.duiba.projectx.sdk.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * @description:
 * @author: liupu1
 * @create: 2020/11/9 10:28 AM
 **/
public class GoldMinerConfigData {

    /**
     * 基础元素列表（包含宝箱）
     */
    private List<GMElementData> baseElements;

    /**
     * 道具列表
     */
    private List<GMSpData> sps;

    /**
     * 关卡列表
     */
    private List<GMLevelData> levels;


    public List<GMElementData> getBaseElements() {
        return baseElements;
    }

    public void setBaseElements(List<GMElementData> baseElements) {
        this.baseElements = baseElements;
    }

    public List<GMSpData> getSps() {
        return sps;
    }

    public void setSps(List<GMSpData> sps) {
        this.sps = sps;
    }

    public List<GMLevelData> getLevels() {
        return levels;
    }

    public void setLevels(List<GMLevelData> levels) {
        this.levels = levels;
    }


    public static void main(String[] args) {

        GoldMinerConfigData config = new GoldMinerConfigData();
        GMElementData elementData1 = new GMElementData();
        elementData1.setElementId(GMElementEnum.ROCK_SMALL.getCode());
        elementData1.setGoldCoin(2);
        elementData1.setVelocity(20);


        GMRuleData rule1 = new GMRuleData();
        rule1.setSpId(GMSpEnum.GOLD_COIN.getCode());
        rule1.setRate("80.1234");

        GMRuleData rule2 = new GMRuleData();
        rule2.setSpId(GMSpEnum.BOMB.getCode());
        rule2.setRate("19.8766");

        List<GMRuleData> rules = Lists.newArrayList();

        rules.add(rule1);
        rules.add(rule2);

        GMElementData elementData2 = new GMElementData();
        elementData2.setElementId(GMElementEnum.TREASUER_BOX.getCode());
        elementData2.setGoldCoin(3);
        elementData2.setVelocity(30);
        elementData2.setRules(rules);

        List<GMElementData> elements = Lists.newArrayList();
        elements.add(elementData1);
        elements.add(elementData2);

        config.setBaseElements(elements);

        GMSpData bomb = new GMSpData();
        bomb.setSpId(GMSpEnum.BOMB.getCode());

        GMSpData midas = new GMSpData();
        midas.setSpId(GMSpEnum.MIDAS_TOUCH.getCode());

        GMRuleData spRule = new GMRuleData();
        spRule.setSpId(GMSpEnum.GOLD_COIN.getCode());
        spRule.setRate("100.0000");

        List<GMRuleData> spRules = Lists.newArrayList();
        spRules.add(spRule);

        GMSpData lucky = new GMSpData();
        lucky.setSpId(GMSpEnum.LUCKY_CLOVER.getCode());
        lucky.setRules(spRules);

        GMSpData vigorous = new GMSpData();
        vigorous.setSpId(GMSpEnum.VIGOROUS_POTION.getCode());
        vigorous.setVelocityUpRate(20);

        GMSpData potential = new GMSpData();
        potential.setSpId(GMSpEnum.POTENTIAL_STOCK.getCode());
        potential.setValueUpRate(30);

        List<GMSpData> sps = Lists.newArrayList();
        sps.add(bomb);
        sps.add(midas);
        sps.add(lucky);
        sps.add(vigorous);
        sps.add(potential);

        config.setSps(sps);

        GMMapElementData mapElement1 = new GMMapElementData();
        mapElement1.setElementId(GMElementEnum.ROCK_SMALL.getCode());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("x", 100);
        jsonObject.put("y", 50);

        mapElement1.setConfigJson(jsonObject.toJSONString());

        GMMapElementData mapElement2 = new GMMapElementData();
        mapElement2.setElementId(GMElementEnum.TREASUER_BOX.getCode());
        jsonObject.put("x", 60);
        jsonObject.put("y", 80);
        mapElement2.setConfigJson(jsonObject.toJSONString());

        List<GMMapElementData> mapElements = Lists.newArrayList();
        mapElements.add(mapElement1);
        mapElements.add(mapElement2);

        GMMapData gmMapData = new GMMapData();
        gmMapData.setMapId(1);
        gmMapData.setBaseElements(mapElements);

        List<GMMapData> maps = Lists.newArrayList();
        maps.add(gmMapData);

        GMBuySpData buySp1 = new GMBuySpData();
        buySp1.setSpId(GMSpEnum.BOMB.getCode());
        buySp1.setGoldCoin(10);

        GMBuySpData buySp2 = new GMBuySpData();
        buySp2.setSpId(GMSpEnum.VIGOROUS_POTION.getCode());
        buySp2.setGoldCoin(15);

        List<GMBuySpData> buySps = Lists.newArrayList();
        buySps.add(buySp1);
        buySps.add(buySp2);


        GMLevelData level = new GMLevelData();
        level.setLelelId(1);
        level.setGoal(100);
        level.setCountDown(300);
        level.setCanBuySp(1);
        level.setBuySps(buySps);
        level.setMapNum(1);
        level.setMaps(maps);


        List<GMLevelData> levels = Lists.newArrayList();
        levels.add(level);

        config.setLevels(levels);

        System.out.println(JSON.toJSONString(config));

    }
}
