package cn.com.duiba.projectx.sdk.repeatable.annotation;

import cn.com.duiba.projectx.sdk.repeatable.Component;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * MVP导入其他类
 * 如果在MVP中使用了该注解，MVP中将不会自动引入其他类或接口，例如组件类中的前端接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: MvpImport.java , v 0.1 2020-04-02 10:55 上午 ZhouFeng Exp $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface MvpImport {

    /**
     * 导入组件类，并注册其前端接口
     *
     * @return
     */
    Class<? extends Component<?>>[] componentClasses();


}
