
/**
 * ---------自定义代码 参与玩法doJoin接口 demo-------------------------------------------------------
 **/
package cn.com.duiba.projectx.sdk.demo;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.playway.JoinUserRequestApi;
import cn.com.duiba.projectx.sdk.template.TemplatePresetAction;
import cn.com.duiba.projectx.sdk.utils.HttpCallback;

public class JoinAction implements TemplatePresetAction<JoinUserRequestApi> {

    @Override
    public boolean accessableCheck(JoinUserRequestApi api, UserRequestContext context) {

        api.getProjectApi().getHttpAsyncClient().submitGet("http://www.baidu.com", null, new HttpCallback() {
            @Override
            public void completed(String result) {
                //System.out.println(result);
                Long a = null;
                try {
                    a = api.getProjectApi().getSomebodyStageProperty("1","1");
                } catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("a:"+a);
            }

            @Override
            public void failed(Exception e) {
                System.out.println(e.getMessage());
            }
        });

        //验证今日参与次数是否已用完
        Integer joinLimit = api.getIntVariable("joinLimit");
        Long todayNum = api.queryMyTodayCount();
        if (todayNum >= joinLimit) {
            throw new BizRuntimeException("今日参与次数已用完");
        }
        return true;
    }

    @Override
    public boolean ticketCheck(JoinUserRequestApi api, UserRequestContext context) {
        //使用扣积分门票
        String ticketNum = context.getHttpRequest().getParameter("ticketNum");
        return api.useCreditsTicket(ticketNum);
    }

    @Override
    public Object process(JoinUserRequestApi api, UserRequestContext context) {
        //使用发奖策略发一个奖项
        return api.strategyPrize("r249d5f32");
    }

}
