/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.ErrorCode;
import cn.com.duiba.projectx.sdk.InnerBizCode;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.Response;
import cn.com.duiba.projectx.sdk.repeatable.annotation.LocalInvoke;
import cn.com.duiba.projectx.sdk.repeatable.annotation.RemoteInvoke;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentContext<I extends UserRequestApi> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentContext.class);
    private Component<I> component;
    private final Map<String, Method> localMethodMaps = new HashMap<String, Method>();
    private final Map<String, Method> remoteMethodMaps = new HashMap<String, Method>();

    public ComponentContext(Component<I> component) {
        this.component = component;
        Map map = Arrays.stream(component.getClass().getMethods()).filter(m -> m.isAnnotationPresent(LocalInvoke.class)).collect(Collectors.toMap(Method::getName, Function.identity()));
        for (Method method : map.values()) {
            Class<?> returnType = method.getReturnType();
            if (Response.class.isAssignableFrom(returnType)) continue;
            LOGGER.error("\u672c\u5730\u65b9\u6cd5\u521d\u59cb\u5316\u5931\u8d25\uff0c{}.{}\u65b9\u6cd5\u8fd4\u56de\u503c\u5fc5\u987b\u4e3aResponse", (Object)component.getClass().getName(), (Object)method.getName());
            throw new IllegalStateException("\u672c\u5730\u65b9\u6cd5\u521d\u59cb\u5316\u5931\u8d25");
        }
        this.localMethodMaps.putAll(map);
        this.remoteMethodMaps.putAll(Arrays.stream(component.getClass().getMethods()).filter(m -> m.isAnnotationPresent(RemoteInvoke.class)).collect(Collectors.toMap(Method::getName, Function.identity())));
    }

    public Method getLocalAction(String name) {
        return this.localMethodMaps.get(name);
    }

    public Method getRemoteAction(String name) {
        return this.remoteMethodMaps.get(name);
    }

    public Object doRemoteAction(String actionName, Object ... args) {
        try {
            Method action = this.remoteMethodMaps.get(actionName);
            if (action == null) {
                throw new BizRuntimeException(ErrorCode.ERR_10021, "\u65b9\u6cd5\u4e0d\u5b58\u5728");
            }
            return action.invoke(this.component, args);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof BizRuntimeException) {
                throw (BizRuntimeException)t.getCause();
            }
            LOGGER.info("\u6267\u884c\u5931\u8d25", t);
            LOGGER.info("\u65b9\u6cd5\u5185\u90e8\u6267\u884c\u5931\u8d25:{}.{}", new Object[]{this.component.getClass(), actionName, t.getCause()});
            throw new BizRuntimeException(InnerBizCode.SYSTEM_ERROR);
        }
    }
}

