package cn.com.duiba.projectx.sdk;

import java.util.List;
import java.util.Map;

/**
 * 用户请求作用域内可使用的API
 *
 * @author xuhengfei
 */
public interface UserRequestApi {

    /**
     * 扣积分门票是否可用
     *
     * @param ticketNum
     * @return
     */
    boolean isCreditsTicketUsable(String ticketNum);

    /**
     * 使用扣积分门票
     *
     * @param ticketNum 票据单号
     * @return true:验证通过 false:验证失败
     */
    boolean useCreditsTicket(String ticketNum);

    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获得当前Action自动生成的记录ID
     * (预设接口内才能获取到，自定义接口中无法获取到)
     *
     * @return 记录ID
     */
    Long getCurrentRecordId();

    /**
     * 使用发奖策略出奖
     *
     * @param prizeStrategyId 发奖策略ID
     * @return 奖项
     */
    StrategyResult strategyPrize(String prizeStrategyId);

    /**
     * 给当前用户发放一个道具
     *
     * @param spId     道具ID
     * @param quantity 初始化属性值
     * @return 记录ID
     */
    Long giveStageProperty(String spId, int quantity);

    /**
     * 消耗当前用户的道具
     *
     * @param spId     道具ID
     * @param quantity 属性减少数量
     * @return
     */
    Boolean consumeStageProperty(String spId, int quantity);

    /**
     * 当前用户的道具属性增加
     *
     * @param spId     道具ID
     * @param quantity 属性增加数量
     * @return
     */
    Boolean stagePropertyIncr(String spId, int quantity);

    /**
     * 当前用户道具数据减少
     *
     * @param spId     道具ID
     * @param quantity 减少数量
     * @return
     */
    Boolean stagePropertyDecr(String spId, int quantity);

    /**
     * 查询用户某个道具属性
     *
     * @param spId 道具ID
     * @return
     */
    Long queryStageProperty(String spId);

    /**
     * 批量查询用户道具属性
     *
     * @param spIds 道具ID集合
     * @return
     */
    Map<String, Long> queryStageProperty(List<String> spIds);

    /**
     * 兑吧APP签名
     *
     * @param params 需要签名的参数
     * @return params 签名好的参数，里面会加入sign, appKey，timestamp
     */
    Map<String, String> duibaSign(Map<String, String> params);

    /**
     * 获取兑吧用户的DuibaPartnerUserId
     * @return
     */
    String getDuibaPartnerUserId();


}
