package cn.com.duiba.projectx.sdk.component.exchange.dto;


import cn.com.duiba.projectx.sdk.component.enums.TimeUnitEnum;

/**
 * @program: projectx
 * @description: 奖品规则Bo
 * @author: Simba
 * @create: 2021-02-24 11:47
 **/
public class OptionInfoRuleDto {

    /**
     * 发奖规则id
     */
    private String ruleId;
    /**
     * 获取奖项ID
     */
    private String optionId;

    /**
     * 奖项名称
     */
    private String optionName;
    /**
     * 奖项剩余库存
     * 直接发奖情况下视为兑换：在配置了奖项库存的情况下，会返回该值
     * 概率出奖情况下是为抽奖：不返回库存
     */
    private Long optionStock;

    /**
     * 奖项图片
     */
    private String optionImg;

    /**
     * 奖品ID
     */
    private String prizeId;

    /**
     * 奖品类型
     */
    private Integer prizeType;

    /**
     * 位置序号
     */
    private Integer position;

    /**
     * 用户兑换限制次数
     */
    private Integer userLimitCount;

    /**
     * 限制类型 - 时间粒度
     *
     * @see TimeUnitEnum
     */
    private int limitTimeUnit;
    /**
     * 自定义周期-有效期组件id
     */
    private String custPeriodId;

    public String getRuleId() {
        return ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getOptionId() {
        return optionId;
    }

    public void setOptionId(String optionId) {
        this.optionId = optionId;
    }

    public String getOptionName() {
        return optionName;
    }

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public Long getOptionStock() {
        return optionStock;
    }

    public void setOptionStock(Long optionStock) {
        this.optionStock = optionStock;
    }

    public String getOptionImg() {
        return optionImg;
    }

    public void setOptionImg(String optionImg) {
        this.optionImg = optionImg;
    }

    public String getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(String prizeId) {
        this.prizeId = prizeId;
    }

    public Integer getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(Integer prizeType) {
        this.prizeType = prizeType;
    }

    public Integer getPosition() {
        return position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public Integer getUserLimitCount() {
        return userLimitCount;
    }

    public void setUserLimitCount(Integer userLimitCount) {
        this.userLimitCount = userLimitCount;
    }

    public int getLimitTimeUnit() {
        return limitTimeUnit;
    }

    public void setLimitTimeUnit(int limitTimeUnit) {
        this.limitTimeUnit = limitTimeUnit;
    }

    public String getCustPeriodId() {
        return custPeriodId;
    }

    public void setCustPeriodId(String custPeriodId) {
        this.custPeriodId = custPeriodId;
    }
}

