package cn.com.duiba.projectx.sdk.component.period;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.period.dto.PeriodResult;

public interface PeriodApi extends UserRequestApi {

    /**
     * 查询场次
     * <p>当前时间是否在场次内
     *
     * @param playwayId 玩法ID
     * @return
     */
    PeriodResult query(String playwayId);

    /**
     * 查询场次
     * <p>当前时间是否在场次内
     *
     * @param playwayId 玩法ID
     * @param afterAllowSeconds 场次结束时间后, 允许几秒后在场次内
     * @return
     */
    PeriodResult query(String playwayId, int afterAllowSeconds);

    /**
     * 参与
     * @param playwayId
     * @return
     */
    PeriodResult join(String playwayId);

    /**
     * 发奖
     * <p>1.当前时间是否在场次内
     * <p>2.满足发奖条件,发放对应奖励
     *
     * @param playwayId 玩法ID
     * @param index 次数
     * @return
     */
    PrizeResult sendPrize(String playwayId, int index);

    /**
     * 发奖
     * <p>1.当前时间是否在场次内
     * <p>2.满足发奖条件,发放对应奖励
     *
     * @param playwayId 玩法ID
     * @param index 次数
     * @param afterAllowSeconds 场次结束时间后, 几秒后允许领奖
     * @return
     */
    PrizeResult sendPrize(String playwayId, int index, int afterAllowSeconds);
}
