package cn.com.duiba.projectx.sdk.playway.invite;

import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.util.List;
import java.util.Optional;

public interface InviteUserRequestApi extends UserRequestApi{
    /**
     * 获取当前用户全部邀请记录
     * @return List<AcceptInviteRecord>
     */
    List<AcceptInvite> getAllMyInviteList();

    /**
     * 获取我今天邀请成功的记录
     * @return
     */
    List<AcceptInvite> getAllMyTodayInviteList();

    /**
     * 获取某人的全部邀请记录
     * @param userId userId
     * @return list
     */
    List<AcceptInvite> getSomebodyAllInviteList(String userId);

    /**
     * 获取某人的当日邀请记录
     * @param userId userId
     * @return list
     */
    List<AcceptInvite> getSomebodyTodayInviteList(String userId);
    /**
     * 查询我的邀请码，如果数据库不存在，返回null
     * @return
     */
    String findInviteCode();

    /**
     * 通过邀请码返回用户id
     * @param code 邀请码
     * @return userId
     */
    Optional<String> getInviterByCode(String code);
    /**
     *
     * @param codeLength 希望的code长度，建议不小于6位，位数过短会导致生成的code重复，创建失败
     * @return
     */
    String getOrGenCode(int codeLength);

    /**
     *
     * @param codes 自己创建Code，需要自行保证Code的唯一性
     * @return
     */
    String getOrGenCode(String... codes);

    /**
     * 接受邀请
     * @param code
     * @return
     */
    void acceptInvite(String code);

    /**
     * 接收邀请并设置extra
     * extra最长255，支持emoji
     * @param code invite code
     * @param extra extra info
     */
    void acceptInvite(String code, String extra);
}
