package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;

import java.lang.reflect.Method;

/**
 * 组件统一接口
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: Component.java , v 0.1 2020-01-21 9:53 上午 ElinZhou Exp $
 */
public interface Component<I extends UserRequestApi> extends EventContextType {

    /**
     * @param name
     * @return {@link Method}
     */
    Method getAction(String name);

    /**
     * @param name
     * @return {@link Method}
     */
    Method getRemoteAction(String name);

    /**
     * @return {@link String}
     */
    String getId();

    /**
     * 执行前端action
     *
     * @param actionName
     * @param args
     * @return {@link Object}
     */
    Object doRemoteAction(String actionName, Object... args);
}
