package cn.com.duiba.projectx.sdk.component;

import cn.com.duiba.projectx.sdk.Api;
import cn.com.duiba.projectx.sdk.component.bindphone.BindPhoneApi;
import cn.com.duiba.projectx.sdk.component.carousel.CarouselApi;
import cn.com.duiba.projectx.sdk.component.checkin.CheckinApi;
import cn.com.duiba.projectx.sdk.component.collectsp.CollectSpApi;
import cn.com.duiba.projectx.sdk.component.countdown.CountdownApi;
import cn.com.duiba.projectx.sdk.component.drawprize.DrawPrizeApi;
import cn.com.duiba.projectx.sdk.component.exchange.ExchangeApi;
import cn.com.duiba.projectx.sdk.component.grade.GradeApi;
import cn.com.duiba.projectx.sdk.component.inviteassist.InviteAssistApi;
import cn.com.duiba.projectx.sdk.component.newguide.NewGuideApi;
import cn.com.duiba.projectx.sdk.component.participate.ParticipateApi;
import cn.com.duiba.projectx.sdk.component.pendingprize.PendingPrizeApi;
import cn.com.duiba.projectx.sdk.component.period.PeriodApi;
import cn.com.duiba.projectx.sdk.component.rank.RankApi;
import cn.com.duiba.projectx.sdk.component.sendprize.SendPrizeApi;
import cn.com.duiba.projectx.sdk.component.share.ShareApi;
import cn.com.duiba.projectx.sdk.component.task.TaskApi;
import cn.com.duiba.projectx.sdk.component.user.ExpendApi;
import cn.com.duiba.projectx.sdk.component.user.UserMarkApi;

/**
 * @program: projectx
 * @description: 组件 API 集合
 * @author: Simba
 * @create: 2021-02-19 16:50
 **/
public interface ComponentApi extends Api {

    /**
     * 获取用户标识Api
     *
     * @return
     */
    UserMarkApi getUserMarkApi();

    /**
     * 获取发奖组件Api
     */
    SendPrizeApi getSendPrizeApi();

    /**
     * 获取发奖组件Api
     */
    PendingPrizeApi getPendingPrizeApi();

    /**
     * 获取分享组件Api
     */
    ShareApi getShareApi();

    /**
     * 获取有效期Api
     */
    PeriodApi getPeriodApi();

    /**
     * 邀请助力组件Api
     */
    InviteAssistApi getInviteAssistApi();

    /**
     * 获取签到Api
     */
    CheckinApi getCheckinApi();

    /**
     * 获取签到Api
     */
    GradeApi getGradeApi();

    /**
     * 获取排行榜Api
     * @return
     */
    RankApi getRankApi();

    /**
     * 获取兑换组件api
     */
    ExchangeApi getExchangeApi();

    /**
     * 获取手机绑定组件api
     */
    BindPhoneApi getBindPhoneApi();

    /**
     * 获取倒计时组件Api
     */
    CountdownApi getCountdownApi();

    /**
     * 获取新手引导组件api
     */
    NewGuideApi getNewGuideApi();

    /**
     * 获取任务组件api
     */
    TaskApi getTaskApi();

    /**
     *  消耗预警组件
     * @return
     */
    ExpendApi getExpendApi();

    /**
     * 获取道具收集组件api
     */
    CollectSpApi getCollectSpApi();

    /**
     * 获取轮播组件api
     */
    CarouselApi getCarouselApi();

    /**
     * 获取参与组件api
     */
    ParticipateApi getParticipateApi();

    /**
     * 获取抽奖组件api
     */
    DrawPrizeApi getDrawPrizeApi();

}

