package cn.com.duiba.projectx.sdk.component.inviteassist;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.AssistRecordResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.AssistResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteAssistQueryParam;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteRecordResult;
import cn.com.duiba.projectx.sdk.component.inviteassist.dto.InviteResult;
import cn.com.duiba.projectx.sdk.utils.PageList;

import java.util.List;

public interface InviteAssistApi extends UserRequestApi {

    /**
     * 获取邀请码
     *
     * @param playwayId 玩法ID
     * @return
     */
    InviteResult getInviteCode(String playwayId);

    /**
     * 获取用户Id
     *
     * @param inviteCode 邀请码
     * @return
     */
    String getUserIdByInviteCode(String inviteCode);

    /**
     * 助力
     * <p>1. 助力条件判断
     * <p>2. 接受邀请
     * <p>3. 给分享者发奖
     *
     *  ⚠️ 请使用邀请风控 @InviteRiskControl
     *
     * @param playwayId 玩法ID
     * @param inviteCode 邀请码
     * @param extra 扩展值
     * @return
     */
    AssistResult doAssist(String playwayId, String inviteCode, String extra);


    /**
     * 查询新邀请数量
     * <p>时间倒序
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    int queryNewInviteCount(String playwayId, String userId);

    /**
     * 查询今日的邀请记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<InviteRecordResult> queryTodayInviteRecords(String playwayId, String userId);

    /**
     * 查询邀请记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param param 查询参数
     * @return
     */
    PageList<InviteRecordResult> queryInviteRecords(InviteAssistQueryParam param);

    /**
     * 查询今日的助力记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    List<AssistRecordResult> queryTodayAssistRecords(String playwayId, String userId);

    /**
     * 查询助力记录
     * <p>时间倒序
     * <p>返回最近300条记录
     *
     * @param param 查询参数
     * @return
     */
    PageList<AssistRecordResult> queryAssistRecords(InviteAssistQueryParam param);

}
