/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.InitializationContext;
import cn.com.duiba.projectx.sdk.repeatable.ActionNode;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.ComponentContext;
import cn.com.duiba.projectx.sdk.repeatable.ComponentFactory;
import cn.com.duiba.projectx.sdk.repeatable.NodeFactory;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent<I extends UserRequestApi>
implements Component<I> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractComponent.class);
    private ComponentContext<I> context;
    private String id;

    public AbstractComponent(String id) {
        this.id = id;
        this.context = new ComponentContext(this);
    }

    public static <I extends UserRequestApi> ActionNode<I> nodeWithAction(Class<? extends Component<I>> componentClass, String action, InitializationContext initializationContext) {
        return AbstractComponent.nodeWithAction(componentClass, action, initializationContext, "");
    }

    public static <I extends UserRequestApi> ActionNode<I> nodeWithAction(Class<? extends Component<I>> componentClass, String action, InitializationContext initializationContext, String id) {
        Component component = ComponentFactory.createAndRegister(componentClass, initializationContext, id);
        ActionNode node = new ActionNode(component, action);
        NodeFactory.put(node);
        return node;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Method getAction(String name) {
        return this.context.getLocalAction(name);
    }

    @Override
    public Method getRemoteAction(String name) {
        return this.context.getRemoteAction(name);
    }

    @Override
    public Object doRemoteAction(String actionName, Object ... args) {
        return this.context.doRemoteAction(actionName, args);
    }
}

