package cn.com.duiba.projectx.sdk.demo;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.TimerApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.annotation.TimerTriggerAction;
import cn.com.duiba.projectx.sdk.playway.luckycode.Luckycode;
import cn.com.duiba.projectx.sdk.playway.luckycode.LuckycodePlaywayInstance;
import cn.com.duiba.projectx.sdk.playway.luckycode.LuckycodeUserRequestApi;
import cn.com.duiba.projectx.sdk.timerapis.LuckycodeTimerApi;

import java.util.*;

public class LuckycodeDemo extends LuckycodePlaywayInstance{

    private static final String periodical="P1";
    @Override
    public Object sendoutLuckycode(UserRequestContext context, LuckycodeUserRequestApi api) {
        String code=codeGen();
        api.addMyLuckycode(periodical,code);
        return code;
    }

    private String codeGen(){
        return String.valueOf(new Random().nextInt());
    }

    @TimerTriggerAction("0 23 19 * * ?")
    public void timerOpenPrize(TimerApi api, LuckycodeTimerApi luckycodeTimerApi){

        String prize1="one";//api.getStringVariable("one");//一等奖
        String prize2="two";//api.getStringVariable("two");//二等奖

        String luckycode="1234";
        List<Luckycode> one=luckycodeTimerApi.queryAllByLuckycode(periodical,luckycode);
        List<Luckycode> two=luckycodeTimerApi.queryAllByLuckycodePrefix(periodical,luckycode.substring(0,luckycode.length()-2));
        two=removeDuplicate(two,one);//排除一等奖

        //标记一等奖
        for(Luckycode l:one){
            luckycodeTimerApi.updatePrizeContent(l.getId(),"一等奖",null,null);
        }
        //标记二等奖
        for(Luckycode l:two){
            luckycodeTimerApi.updatePrizeContent(l.getId(),"二等奖",null,null);
        }

        //一等奖发奖
        for(Luckycode l:one){
            //标记已发奖
            luckycodeTimerApi.updatePrizeContent(l.getId(),null,prize1,new Date());
            boolean success=api.sendPrizeWithDirect("夺宝开奖",l.getUserId(),prize1);
            if(!success){
                throw new BizRuntimeException("开奖异常");
            }
        }
        //二等奖发奖
        for(Luckycode l:two){
            //标记已发奖
            luckycodeTimerApi.updatePrizeContent(l.getId(),null,prize2,new Date());
            boolean success=api.sendPrizeWithDirect("夺宝开奖",l.getUserId(),prize2);
            if(!success){
                throw new BizRuntimeException("开奖异常");
            }
        }

    }

    private List<Luckycode> removeDuplicate(List<Luckycode> origion,List<Luckycode> filter){
        Set<Long> filterIds=new HashSet<>();
        for(Luckycode l:filter){
            filterIds.add(l.getId());
        }
        Iterator<Luckycode> it=origion.iterator();
        while (it.hasNext()){
            Luckycode l=it.next();
            if(filterIds.contains(l.getId())){
                it.remove();
            }
        }
        return origion;
    }
}
