package cn.com.duiba.projectx.sdk.demo;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.annotation.CustomRequestAction;
import cn.com.duiba.projectx.sdk.playway.scoring.ScoringPlaywayInstance;
import cn.com.duiba.projectx.sdk.playway.scoring.ScoringUserRequestApi;
import cn.com.duiba.projectx.sdk.utils.RankingApi;


public class ScoringDemo extends ScoringPlaywayInstance{

    private static final boolean high2low=true;

    @Override
    public void config(ScoringConfig config) {
        config.userConcurrentLockExpirTime=null;
        config.allowMultiSubmit=true;
    }

    @Override
    public Object start(UserRequestContext context, ScoringUserRequestApi api) {
        return api.getCurrentRecordId();
    }

    @Override
    public Object submit(Long startId,int score, UserRequestContext context, ScoringUserRequestApi api) {
        //提交分数
        api.submitScore(startId,score);
        //更新排行榜
        RankingApi rankingApi= api.getRankingApi();
        rankingApi.updateRankingScore("type",score,high2low);


        return "ok";
    }


    @CustomRequestAction(id="ok",name = "ok")
    public Object ok(UserRequestContext context,ScoringUserRequestApi api){
        return 666;
    }
}
