package cn.com.duiba.projectx.sdk.component.rank;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.base.Ranking;
import cn.com.duiba.projectx.sdk.playway.base.RankingUserPrizeRecord;

import java.util.List;

public interface RankApi extends UserRequestApi {

    /**
     * 新排行榜，更改底层maxScoreOrder生成规则
     * @param rankPlaywayId
     * @param userId
     * @param score
     * @return
     */
    void submit(String rankPlaywayId, String userId, int score);

    /**
     * 更新排行榜分数
     * @param score 分值
     */
    void updateRankScore(String rankPlaywayId, String userId, String rankType, int score);

    /**
     * 获取前几名的排行榜信息
     * @param rankPlaywayId 排行榜玩法ID
     * @param topN 前几名
     *             不允许调用超过3000名的排名，会有性能问题
     * @return ranking 列表
     */
    List<Ranking> getTopN(String rankPlaywayId, int topN);

    /**
     * 获取上期排行榜当前用户信息
     * 排行榜已结束-返回最后一期
     * 排行榜未结束-返回上一期
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     */
    RankingUserPrizeRecord getPreMyRank(String rankPlaywayId);

    /**
     * 获取新排行榜当前正在进行中的rankingType
     * 如果排行榜已结束，返回的是最后一期
     * 如果排行榜未开始，返回的是第一期
     * @param rankPlaywayId 排行榜玩法ID
     * @return
     * @throws BizRuntimeException
     */
    String getCurrentRankingType(String rankPlaywayId) throws BizRuntimeException;

    /**
     * 获取新排行榜上一期的rankingType
     * @param rankPlaywayId 排行榜玩法ID
     *
     * @return
     * @throws BizRuntimeException
     */
    String getPrefixRankingType(String rankPlaywayId) throws BizRuntimeException;
}
