package cn.com.duiba.projectx.sdk.component.task;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.base.PrizeResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskItemConfig;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskQueryResult;
import cn.com.duiba.projectx.sdk.component.task.dto.TaskResult;

import java.util.Date;
import java.util.Map;

public interface TaskApi extends UserRequestApi {

    /**
     * 查询配置
     *
     * @param playwayId 玩法ID
     * @return
     *  key = 任务id
     *  value = 任务配置
     */
    Map<String, TaskItemConfig> queryConfig(String playwayId);

    /**
     * 查询配置
     *
     * @param playwayId 玩法ID
     * @return
     *  key = 任务code
     *  value = 任务配置
     */
    Map<String, TaskItemConfig> queryConfigForCodeKey(String playwayId);

    /**
     * 查询配置的任务列表
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    TaskQueryResult queryTasks(String playwayId, String userId);

    /**
     * 查询任务完成的次数
     *
     * @param playwayId 玩法ID
     * @param userId 用户ID
     * @return
     */
    Map<String, Long> getTaskCompletedCount(String playwayId, String userId, Date startDate, Date endDate);

    /**
     * 完成任务
     *  请调用 api.doCompleted()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    TaskResult doCompleted(String playwayId, String userId, String taskId);

    /**
     * 完成任务
     *  请调用 api.doCompletedForCode()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param userId
     * @param taskCode
     * @return
     */
    TaskResult doCompletedForCode(String playwayId, String userId, String taskCode);

    /**
     * 完成任务并发奖
     *  请调用 api.doCompletedAndSendPrize()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param userId
     * @param taskId
     * @return
     */
    TaskResult doCompletedAndSendPrize(String playwayId, String userId, String taskId);

    /**
     * 完成任务并发奖
     *  请调用 api.doCompletedAndSendPrizeForCode()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     * @param playwayId
     * @param userId
     * @param taskCode
     * @return
     */
    TaskResult doCompletedAndSendPrizeForCode(String playwayId, String userId, String taskCode);

    /**
     * 领取奖励
     *  请调用 api.sendPrize()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId
     * @param userId
     * @param taskId
     * @param prizePendingCode 待领奖code
     * @return
     */
    PrizeResult sendPrize(String playwayId, String userId, String taskId, String prizePendingCode);

    /**
     * 领取奖励
     *  请调用 api.sendPrizeForCode()
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId
     * @param userId
     * @param taskCode
     * @param prizePendingCode 待领奖code
     * @return
     */
    PrizeResult sendPrizeForCode(String playwayId, String userId, String taskCode, String prizePendingCode);

}
