package cn.com.duiba.projectx.sdk.pay;

public class TransferAccountRequest {

  /** 应用ID */
  private final Long appId;

  /** 兑吧用户ID */
  private final Long consumerId;

  /** 订单号 */
  private final Long orderId;

  /** 划账金额，单位：分 */
  private final Long amount;

  /** 划账渠道：当前支持中信全付通划账（开发侧channel=bank_of_citic_wap） */
  private final String channel;

  public TransferAccountRequest(Long appId, Long consumerId, Long orderId, Long amount, String channel) {
    this.appId = appId;
    this.consumerId = consumerId;
    this.orderId = orderId;
    this.amount = amount;
    this.channel = channel;
  }

  public Long getAppId() {
    return appId;
  }

  public Long getConsumerId() {
    return consumerId;
  }

  public Long getOrderId() {
    return orderId;
  }

  public Long getAmount() {
    return amount;
  }

  public String getChannel() {
    return channel;
  }
}
