package cn.com.duiba.projectx.sdk.utils;

import cn.com.duiba.projectx.sdk.querytable.QueryWrapper;
import cn.com.duiba.projectx.sdk.querytable.SFunction;

import java.util.List;

/**
 * Author: DSG
 * Date: 11:24 2021/7/30
 * Description: QueryTable操作工具
 */
public interface QueryTableSp<T> {
    /**
     * 添加一条数据
     * @param t
     */
    void add(T t);

    /**
     * 通过id删除一条数据
     * @param id
     */
    void delete(long id);

    /**
     * 通过id修改一条数据
     * @param t
     * @return
     */
    boolean updateById(T t);

    /**
     * 通过条件修改数据
     * @param queryWrapper
     * @param t
     * @return
     */
    long update(QueryWrapper<T> queryWrapper,T t);

    /**
     * 通过id递增score值
     * @param id
     * @param delta 自增值
     * @param limit   限制, 如果是递增,则结果不能大于limit ,如果是递减,则结果不能小于limit
     * @return
     */
    boolean increment(long id, long delta, long limit);

    /**
     * 通过条件查询一条数据
     * @param queryWrapper
     * @return
     */
    T queryOne(QueryWrapper<T> queryWrapper);

    /**
     * 通过一个条件查询一条数据
     * @param function
     * @param o
     * @return
     */
    T queryOne(SFunction<T,?> function, Object o);

    /**
     * 通过条件查询列表 最多2000条
     * @param queryWrapper
     * @return
     */
    List<T> queryList(QueryWrapper<T> queryWrapper);

    /**
     * 通过一个条件查询列表, 最多2000条
     * @param function
     * @param o
     * @return
     */
    List<T> queryList(SFunction<T,?> function, Object o);

    /**
     * 通过自定义条件翻页查询
     * @param queryWrapper
     * @param pageNum 从1开始
     * @param pageSize 最大2000
     * @return
     */
    PageList<T> pageQuery(QueryWrapper<T> queryWrapper,long pageNum, long pageSize);

    /**
     * 通过一个条件翻页查询
     * @param function
     * @param o
     * @param pageNum 从1开始
     * @param pageSize 最大2000
     * @return
     */
    PageList<T> pageQuery(SFunction<T,?> function, Object o,long pageNum, long pageSize);

    /**
     * 获取一个新的条件构造对象
     * @return
     */
    QueryWrapper<T> getQueryWrapper();
}
