/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.repeatable.ActionNode;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.EventContext;
import cn.com.duiba.projectx.sdk.repeatable.Response;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class ActionChain<I extends UserRequestApi> {
    private String name;
    private List<ActionNode<I>> chain = new ArrayList<ActionNode<I>>();

    @Deprecated
    public ActionChain() {
    }

    public ActionChain(String name) {
        this.name = name;
    }

    public ActionChain(List<ActionNode<I>> nodes) {
        this.chain = nodes;
    }

    public ActionChain<I> add(Component<I> component, String action) {
        this.chain.add(new ActionNode<I>(component, action));
        return this;
    }

    public ActionChain<I> add(ActionNode<I> node) {
        this.chain.add(node);
        return this;
    }

    public Response<I> invoke(EventContext eventContext, UserRequestContext userRequestContext, I api) {
        Response fullResponse = new Response();
        for (ActionNode<I> node : this.chain) {
            Response<I> response = node.doAction(eventContext, userRequestContext, api);
            if (response.isInterrupt()) {
                return response;
            }
            if (!CollectionUtils.isEmpty(response.getInsetNodes())) {
                Response<I> subResponse = new ActionChain<I>(response.getInsetNodes()).invoke(eventContext, userRequestContext, api);
                if (subResponse.isInterrupt()) {
                    return response;
                }
                fullResponse.putAllData(response.getDataMap());
            }
            fullResponse.putAllData(response.getDataMap());
        }
        return fullResponse;
    }

    public String getName() {
        return this.name;
    }
}

