/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.repeatable.ActionNode;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import com.google.common.collect.HashBasedTable;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NodeFactory {
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock(false);
    private static final HashBasedTable<Class<? extends Component<? extends UserRequestApi>>, String, ActionNode<? extends UserRequestApi>> CONTAINER = HashBasedTable.create();

    private NodeFactory() {
        throw new UnsupportedOperationException();
    }

    public static void put(ActionNode<? extends UserRequestApi> node) {
        ReentrantReadWriteLock.WriteLock writeLock = LOCK.writeLock();
        try {
            writeLock.lock();
            CONTAINER.put(node.getComponent().getClass(), (Object)NodeFactory.componentKey(node.getComponent().getId(), node.actionName()), node);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ActionNode<? extends UserRequestApi>, V extends Component<? extends UserRequestApi>> T get(Class<V> clazz, String id, String actionName) {
        ReentrantReadWriteLock.ReadLock readLock = LOCK.readLock();
        try {
            readLock.lock();
            ActionNode actionNode = (ActionNode)CONTAINER.get(clazz, (Object)NodeFactory.componentKey(id, actionName));
            return (T)actionNode;
        }
        finally {
            readLock.unlock();
        }
    }

    private static String componentKey(String id, String actionName) {
        return id + "_" + actionName;
    }
}

