package cn.com.duiba.projectx.sdk.component.base;

import java.io.Serializable;
import java.util.Objects;

public class PageParam implements Serializable {
    private static final long serialVersionUID = 1116160295431251866L;

    /**
     * 页码，从1开始
     */
    private Integer pageNum = 1;

    /**
     * 每页数据数量,默认20
     */
    private Integer pageSize = 20;

    public Integer getPageNum() {
        if (Objects.isNull(pageNum) || pageNum <= 0) {
            return 1;
        }
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return Objects.isNull(pageSize) ? 20 : pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        return (getPageNum() - 1) * getPageSize();
    }
}
