package cn.com.duiba.projectx.sdk.component.collectaward.enums;

/**
 * @program: projectx
 * @description: 收集条件出奖收集类型枚举
 * @author: Simba
 * @create: 2021-05-10 20:23
 **/
public enum CollectAwardCollectTypeEnum {

    ASSIGN_SP(1, "收集指定道具"),

    SP_CATEGORY(2, "收集道具种类数"),
    ;

    private int type;

    private String desc;

    CollectAwardCollectTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CollectAwardCollectTypeEnum toEnum(int type) {
        for (CollectAwardCollectTypeEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}