package cn.com.duiba.projectx.sdk.component.exchange.enums;

/**
 * @program: projectx
 * @description: 限制类型枚举
 * @author: Simba
 * @create: 2021-03-04 13:40
 **/
public enum ExchangeLimitTypeEnum {

    CONSUME_NUM(1, "消耗同一个道具"),

    CONSUME_TOGETHER(2, "消耗一套道具"),
    /**
     * 暂时一期不支持
     */
    CONSUME_NONE(3, "不消耗道具"),
    ;

    private int type;

    private String desc;

    ExchangeLimitTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static ExchangeLimitTypeEnum toEnum(int type) {
        for (ExchangeLimitTypeEnum p : values()) {
            if (p.type == type) {
                return p;
            }
        }
        return null;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}

