package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.UserRequestContext;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ActionChain.java , v 0.1 2020-01-21 10:15 上午 ZhouFeng Exp $
 */
public class ActionChain<I extends UserRequestApi> {

    private String name;

    private List<ActionNode<I>> chain = new ArrayList<>();

    /**
     * @deprecated 使用ActionChain(String name)
     */
    @Deprecated
    public ActionChain() {
    }

    public ActionChain(String name) {
        this.name = name;
    }

    public ActionChain(List<ActionNode<I>> nodes) {
        this.chain = nodes;
    }

    public ActionChain<I> add(Component<I> component, String action) {
        chain.add(new ActionNode<I>(component, action));
        return this;
    }

    public ActionChain<I> add(ActionNode<I> node) {
        chain.add(node);
        return this;
    }

    public Response<I> invoke(EventContext eventContext, UserRequestContext userRequestContext, I api) {
        Response<I> fullResponse = new Response<>();

        for (ActionNode<I> node : chain) {
            Response<I> response = node.doAction(eventContext, userRequestContext, api);
            if (response.isInterrupt()) {
                return response;
            }
            if (!CollectionUtils.isEmpty(response.getInsetNodes())) {
                //如果该节点需要执行子ActionChain，则优先执行
                Response<I> subResponse = new ActionChain<>(response.getInsetNodes()).invoke(eventContext,
                        userRequestContext, api);
                if (subResponse.isInterrupt()) {
                    return response;
                }
                fullResponse.putAllData(response.getDataMap());
            }
            fullResponse.putAllData(response.getDataMap());
        }
        return fullResponse;
    }

    public String getName() {
        return name;
    }
}
