package cn.com.duiba.projectx.sdk.repeatable.annotation;

import cn.com.duiba.projectx.sdk.repeatable.mvp.Mvp;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 组件远程调用行为注解
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: RemoteInvoke.java , v 0.1 2020-01-21 5:40 下午 ZhouFeng Exp $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface RemoteInvoke {

    /**
     * 接口所在MVP类
     * 不设置此字段时，将会自动寻找相同玩法类型的MVP
     * 如果是通用组件，请不要设置此字段
     *
     * @return
     * @deprecated 该字段将会无效，请使用MvpImport注解，从MVP中依赖组件
     */
    @Deprecated
    Class<? extends Mvp> mvp() default Mvp.class;

    /**
     * 接口前缀
     * 接口格式为${prefix}_${methodName}
     *
     * @return
     */
    String prefix() default "";

    /**
     * 接口id
     *
     * @return
     * @deprecated 请改用methodName(), 或两者均不填
     */
    @Deprecated
    String id() default "";

    /**
     * 接口具体名称，不填时将默认取方法名称
     *
     * @return
     */
    String methodName() default "";

    /**
     * 接口名称
     * 即为接口的描述
     *
     * @return
     */
    String name() default "";

    /**
     * 请求参数的类型
     * 可以在自定义Action的入参中增加此类型参数来获取
     *
     * @return
     */
    Class<?> requestClassType() default Void.class;

}
