package cn.com.duiba.projectx.sdk.repeatable.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

/**
 * 配置工具类
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: ConfigUtils.java , v 0.1 2020-01-31 9:44 下午 ZhouFeng Exp $
 */
public class ConfigUtils {
    private ConfigUtils() {
        throw new UnsupportedOperationException();
    }

    /**
     * 合并配置，运营配置优先于开发配置
     *
     * @param operatorConfig 运营配置
     * @param devProperties  开发配置
     * @return
     */
    public static Map<String, String> merge(Map<String, String> operatorConfig, Properties devProperties) {
        Map<String, String> result = new HashMap<>();
        Optional.ofNullable(devProperties).ifPresent(dev -> dev.forEach((k, v) -> result.put(String.valueOf(k),
                String.valueOf(v))));
        if (operatorConfig != null) {
            for (Map.Entry<String, String> entry : operatorConfig.entrySet()) {
                String operatorKey = entry.getKey();
                if (!operatorKey.startsWith("rpb_")) {
                    continue;
                }
                //运营配置中的key的分隔符是『_』而不是『.』
                String key = entry.getKey().replace("_", ".");
                result.put(key, entry.getValue());
            }
        }

        return result;
    }


}
