package cn.com.duiba.projectx.sdk.component.collectsp;

import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.component.collectsp.dto.CollectSpGiveResult;
import cn.com.duiba.projectx.sdk.component.collectsp.dto.CollectSpIncomeResult;
import cn.com.duiba.projectx.sdk.component.collectsp.dto.CollectSpQueryResult;

public interface CollectSpApi extends UserRequestApi {

    /**
     * 查询道具
     * @param playwayId 玩法Id
     * @return
     */
    CollectSpQueryResult queryUserSps(String playwayId, String userId);

    /**
     * 赠送道具
     * @param playwayId 玩法Id
     * @param spId 道具ID
     * @return
     */
    CollectSpGiveResult getSpCode(String playwayId, String spId);

    /**
     * 赠送道具
     * @param playwayId 玩法Id
     * @param userId 用户ID
     * @param spId 道具ID
     * @param spCount 道具数量
     * @param extra 扩展值
     * @param spCodeLength 赠送码长度
     * @return
     */
    CollectSpGiveResult getSpCode(String playwayId, String userId, String spId, Integer spCount, String extra, int spCodeLength);

    /**
     * 接收道具
     *  ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * @param playwayId 玩法Id
     * @param spCode 赠送码
     * @return
     */
    CollectSpIncomeResult incomeSp(String playwayId, String spCode);
}
