package cn.com.duiba.projectx.sdk.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * 卡片类型
 */
public enum BankTypeEnum {

    JIEJI_CARD(1,"_DEBIT","借记卡"),
    CREDITS_CARD(2,"_CREDIT","信用卡"),

    ;

    BankTypeEnum(int bankType,String suffix, String desc){
        this.bankType = bankType;
        this.suffix = suffix;
        this.desc = desc;
    }
    private static final Map<Integer, BankTypeEnum> ALL_ENUM_MAP = new HashMap<>();
    static{
        for(BankTypeEnum bankType : values()){
            ALL_ENUM_MAP.put(bankType.getBankType(), bankType);
        }
    }

    public static BankTypeEnum getBankType(int type) {
        return ALL_ENUM_MAP.get(type);
    }


    /** 卡片类型 */
    private int bankType;
    /**
     * 后缀
     */
    private String suffix;

    /** 描述 */
    private String desc;

    public int getBankType() {
        return bankType;
    }

    public String getSuffix() {
        return suffix;
    }

    public String getDesc() {
        return desc;
    }
}
