package cn.com.duiba.projectx.sdk.pay.citic;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.pay.BaseRefundResp;

/**
 * Created by HePeng on 2020/11/05 14:57.
 */
public interface CiticPayApi {
    /**
     * 发起支付
     * @param chargeRequest
     * @return
     * @throws BizRuntimeException
     */
    CiticWapPayCenterChargeResponse createCiticCharge(CiticWapPayCenterChargeRequest chargeRequest) throws BizRuntimeException;

    /**
     * 查询支付结果
     * @param bizOrderNo
     * @param bizType
     * @return
     * @throws BizRuntimeException
     */
    CiticPayCenterChargeNotifyResponse queryOrderNotify(String bizOrderNo, Integer bizType) throws BizRuntimeException;

    /**
     * 发起退款
     * @param request
     * @return
     */
    BaseRefundResp citicRefund(CiticPayCenterRefundRequest request);


    /**
     * 后端回调通知
     *
     * @param content 开发者回调通知信息
     * @return
     */
    CiticPayCenterCallbackNotifyResponse callbackNotify(String content);
}
