package cn.com.duiba.projectx.sdk.playway.scoring;

import cn.com.duiba.projectx.sdk.UserRequestContext;
import cn.com.duiba.projectx.sdk.playway.base.PlaywayCommonConfig;

/**
 * 可中途计分玩法的自定义功能实现
 */
public abstract class MultiScoringPlaywayInstance {


    public void config(MultiScoringConfig config) {

    }

    /**
     * 如允许开始游戏，请调用 api.getCurrentRecordId() 获得参与游戏的startId，并将startId返回给前端
     *
     * @param context
     * @param api
     * @return
     */
    public abstract Object start(UserRequestContext context, ScoringUserRequestApi api);

    /**
     * 默认不允许多次提交，如需开放，请配置 ScoringConfig
     * @param startRecord
     * @param score       最高分值：9999999  ，超过将会自动拒绝

     * @param context
     * @param api
     * @return Object
     * Boolean:true 表明允许提交，将自动进行提交动作
     */
    public abstract Object submit(StartRecord startRecord, int score, UserRequestContext context,
                                  ScoringUserRequestApi api);

    /**
     *  中途提交
     * @param startRecord
     * @param score       最高分值：9999999  ，超过将会自动拒绝* @param context
     * @param api
     * @return
     */
    public abstract Object halfwaySubmit(StartRecord startRecord, int score, UserRequestContext context,
                                         ScoringUserRequestApi api);

    /**
     * 最终提交
     * @param startRecord
     * @param context
     * @param api
     * @return
     */
    public abstract Object finalSubmit(StartRecord startRecord,UserRequestContext context,
                                         ScoringUserRequestApi api);

    public static class MultiScoringConfig extends PlaywayCommonConfig<MultiScoringConfig> {
        /**
         * 是否允许一次游戏多次提交
         * 默认不允许多次提交，当多次提交时会自动拒绝
         * <p>
         * 如果开启允许多次提交，第N次提交的合法性，必须配合自定义代码来验证
         */
        protected boolean allowMultiSubmit = false;

        /**
         * 是否开启滑块检验
         */
        protected boolean openSlideValidate = false;
        /**
         * 滑块检验开启阈值（最终提交分数操作次阈值需要进行滑块校验）
         */
        protected int slideValidateOpenThreshold = 0;
        /**
         * 两次提交的时间间隔 默认1s（实际接受 前后3s）
         */
        protected int submitIntervalTime = 1;
        /**
         * 单次提交的最大可分数
         */
        protected int singletonSubmitLimit = Integer.MAX_VALUE;


        public MultiScoringConfig setAllowMultiSubmit(boolean bool) {
            this.allowMultiSubmit = bool;
            return this;
        }

        public MultiScoringConfig setOpenSlideValidate(boolean openSlideValidate) {
            this.openSlideValidate = openSlideValidate;
            return this;
        }

        public MultiScoringConfig setSlideValidateOpenThreshold(int slideValidateOpenThreshold) {
            this.slideValidateOpenThreshold = slideValidateOpenThreshold;
            return this;
        }

        public MultiScoringConfig setSubmitIntervalTime(int submitIntervalTime) {
            this.submitIntervalTime = submitIntervalTime;
            return this;
        }

        public MultiScoringConfig setSingletonSubmitLimit(int singletonSubmitLimit) {
            this.singletonSubmitLimit = singletonSubmitLimit;
            return this;
        }

        public boolean isAllowMultiSubmit() {
            return allowMultiSubmit;
        }

        public boolean isOpenSlideValidate() {
            return openSlideValidate;
        }

        public int getSlideValidateOpenThreshold() {
            return slideValidateOpenThreshold;
        }

        public int getSubmitIntervalTime() {
            return submitIntervalTime;
        }

        public int getSingletonSubmitLimit() {
            return singletonSubmitLimit;
        }

    }

}
