/**
 * Copyright (C), 2015-2020, XXX有限公司
 * FileName: UnionPayApi
 * Author:   xcw
 * Date:     2020/12/9 15:33
 * Description: 浙江银联支付
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.com.duiba.projectx.sdk.pay.union;

import java.util.Map;

/**
 * 〈浙江银联支付〉
 *
 * @author xcw
 * @create 2020/12/9
 * @since 1.0.0
 */
public interface UnionPayApi {


    /**
     * 银联云闪付
     * @param request
     * @return
     */
    UnionChargeResponse createUnionPayCharge(UnionChargeRequest request);

    /**
     * 消费接口后台通知
     * @param map
     * @return
     */
    UnionPayNotifyResp orderNotify(Map<String, String> map);

    /**
     * 银联云闪付支付状态
     * @param payRecordId
     * @return
     */
    UnionPayStatus queryPayStatus(Long payRecordId);

    /**
     * 银联发起退款请求
     * @param unionRefundRequest
     * @return
     */
    UnionRefundResp createRefund(UnionRefundRequest unionRefundRequest);

    UnionRefundNotifyResp refundNotify(Map<String, String> map);
}