package cn.com.duiba.projectx.sdk.playway.base;

public class PlaywayCommonConfig<T extends PlaywayCommonConfig<?>> {
    /**
     * 针对预设接口，是否自动开启并发锁限制(默认关闭)
     */
    protected volatile boolean userlockEnable=false;

    /**
     * 针对预设接口,设置并发锁过期时间(默认3秒)
     */
    protected Integer userlockConcurrentLockExpirTime=3;

    public T setUserlockEnable(boolean enable){
        this.userlockEnable=enable;
        return getThis();
    }

    protected T getThis(){
        return (T)this;
    }

    public T setUserlockConcurrentLockExpireTime(int seconds){
        this.userlockConcurrentLockExpirTime=seconds;
        return getThis();
    }

    public Integer getUserlockConcurrentLockExpirTime() {
        return userlockConcurrentLockExpirTime;
    }

    public boolean isUserlockEnable() {
        return userlockEnable;
    }
}
