package cn.com.duiba.projectx.sdk.utils;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: PageList.java , v 0.1 2019-11-18 16:05 ZhouFeng Exp $
 */
public class PageList<T> {


    /**
     * 总记录数
     */
    private long totalCount;


    /**
     * 总页数
     */
    private long totalPage;

    /**
     * 当前页数据
     */
    private List<T> list;

    public PageList() {
        this.totalCount = 0;
        this.totalPage = 0;
        this.list = Lists.newArrayList();
    }

    public PageList(long totalCount, long pageSize, List<T> list) {
        this.totalCount = totalCount;
        this.list = list;
        this.totalPage = totalPage(pageSize);
    }

    public static <T> PageList<T> of(long totalCount, long pageSize, List<T> list) {
        return new PageList<>(totalCount, pageSize, list);
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private long totalPage(long pageSize) {
        if (totalCount < 1) {
            return 0;
        }
        return (totalCount % pageSize == 0) ? totalCount / pageSize : totalCount / pageSize + 1;
    }


    public long getTotalCount() {
        return totalCount;
    }

    public long getTotalPage() {
        return totalPage;
    }

    public List<T> getList() {
        return list;
    }
}
