/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.projectx.sdk.repeatable;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.ErrorCode;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.playway.InitializationContext;
import cn.com.duiba.projectx.sdk.repeatable.Component;
import cn.com.duiba.projectx.sdk.repeatable.annotation.DevConfig;
import cn.com.duiba.projectx.sdk.repeatable.utils.ConfigUtils;
import cn.com.duiba.projectx.sdk.repeatable.utils.ReflectUtils;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentFactory.class);
    private static final HashBasedTable<Class<? extends Component<? extends UserRequestApi>>, String, Component<? extends UserRequestApi>> CONTAINER = HashBasedTable.create();
    private static final Multimap<ClassLoader, Component<? extends UserRequestApi>> CLASS_LOADER_CLASS_MULTIMAP = HashMultimap.create();

    public static <I extends UserRequestApi> Component<I> createAndRegister(Class<? extends Component<I>> componentClass, InitializationContext initializationContext) {
        return ComponentFactory.createAndRegister(componentClass, initializationContext, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends UserRequestApi> Component<I> createAndRegister(Class<? extends Component<I>> componentClass, InitializationContext initializationContext, String id) {
        Component<I> component = (Component<I>)CONTAINER.get(componentClass, (Object)id);
        if (component == null) {
            Class<Component<I>> clazz = componentClass;
            synchronized (clazz) {
                component = (Component)CONTAINER.get(componentClass, (Object)id);
                if (component == null) {
                    component = ComponentFactory.newInstance(componentClass, initializationContext, id);
                    CONTAINER.put(componentClass, (Object)id, component);
                    CLASS_LOADER_CLASS_MULTIMAP.put((Object)componentClass.getClassLoader(), component);
                }
            }
        }
        return component;
    }

    public static <I extends UserRequestApi> Component<I> get(Class<? extends Component<? extends UserRequestApi>> componentClass, String id) {
        return (Component)CONTAINER.get(componentClass, (Object)id);
    }

    public static List<Component<? extends UserRequestApi>> currentComponents(ClassLoader classLoader) {
        return new ArrayList<Component<? extends UserRequestApi>>(CLASS_LOADER_CLASS_MULTIMAP.get((Object)classLoader));
    }

    private static <I extends UserRequestApi> Component<I> newInstance(Class<? extends Component<I>> componentClass, InitializationContext initializationContext, String id) {
        try {
            Constructor<Component<I>> constructor = componentClass.getConstructor(String.class);
            Component<I> component = constructor.newInstance(id);
            ComponentFactory.populate(component, initializationContext);
            return component;
        }
        catch (BizRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            LOGGER.error("\u521b\u5efa\u7ec4\u4ef6\u5931\u8d25", t);
            throw new BizRuntimeException(ErrorCode.ERR_10000, "\u7cfb\u7edf\u7e41\u5fd9");
        }
    }

    private static void populate(Component<?> component, InitializationContext initializationContext) {
        Class<?> clazz = component.getClass();
        Field[] fields = clazz.getDeclaredFields();
        Properties devProperties = initializationContext.getDevProperties();
        Map<String, String> operationConfig = initializationContext.getOperationConfig();
        Map<String, String> config = ConfigUtils.merge(operationConfig, devProperties);
        for (Field field : fields) {
            double aDouble;
            if (!field.isAnnotationPresent(DevConfig.class)) continue;
            DevConfig devConfig = field.getAnnotation(DevConfig.class);
            String key = ComponentFactory.configKey(component, devConfig.key());
            String value = config.get(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new BizRuntimeException("\u627e\u4e0d\u5230[" + component.getClass().getName() + "." + key + "]\u914d\u7f6e");
            }
            if (NumberUtils.isCreatable((String)value) && ((aDouble = Double.parseDouble(value)) < devConfig.minInclude() || aDouble >= devConfig.maxExclude())) {
                throw new BizRuntimeException(String.format("%s\u503c\u6821\u9a8c\u51fa\u9519,\u8981\u6c42[%s,%s),\u5b9e\u9645:%s", key, devConfig.minInclude(), devConfig.maxExclude(), value));
            }
            ReflectUtils.assign(field, component, value);
        }
    }

    private static String configKey(Component<?> component, String baseKey) {
        if (StringUtils.isBlank((CharSequence)component.getId())) {
            return baseKey;
        }
        return baseKey + "." + component.getId();
    }
}

